/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationFinal;

import productsFinal.*;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestPriceList {

    public static void main(String[] args) {
//        PriceList demo = createDemoPriceList();
//        demo.printList(); 

//        //Only print out the details of the writing implements on the price list
//        for (Item i : demo.list) {
//            if (i instanceof WritingImplement) {
//                i.printProduct();
//            }
//        }

        //Test Taxable Items
        //Creating an instance of SundryItem
//        SundryItem opalCard = new SundryItem("Opal transport card.");
//        opalCard.setPrice(20.0);
//        opalCard.enterDescription("Opal card for buses, trains and ferries.");
        
        //Add it to the demo price list
//        demo.addProduct(opalCard);
        
        //Print out the taxable items name, price and tax payable
//        System.out.println("Taxable Items:");
//        for (Item i : demo.list) {
//            if (i instanceof TaxableItem) {
//                System.out.println(i.getName()+"\tCost: "+i.getPrice()+"\tTax:"
//                        //Treat as a TaxableItem to run calculateTax method.
//                        +((TaxableItem) i).calculateTax());
//            }
//        }

        //Programming to an Interface
        //Using a dummy implementation
//        DataSource ds = new DummyImplementation();
        //Later on we will modify this code to use a different implementation.
//        DataSource ds = new InMemoryDataSource();//Try the in memory one first
        DataSource ds = new FileDataSource();//Now try the file one second.

        //Print the default "Demo" list
        PriceList demo = ds.retrieveList("Demo");
//        demo.printList();

        //Make a new price list containing only
        PriceList writingImplements = new PriceList();
        for (Item i : demo.list) {
            if (i instanceof WritingImplement) {
                writingImplements.addProduct(i);
            }
        } 
        //Add it to our datasource
        ds.saveList("Writing Implements",writingImplements);
        ds.getListNames();
        //Print out both of the lists
        ds.retrieveList("Demo").printList();
        ds.retrieveList("Writing Implements").printList();
        
        
        //Comment out the saveList and rerun, the list wasn't save permanently
        //Change to the file implementation:
        //Note that an obejct (and any objects it contains) 
        //must implement the serializable interface to be save to file.
        
        //Run with the save, then run again without.  The data has been saved.
        //People who now how to do this can write the implementation, 
        //we just have to worry about our own application.
       
    }

//    public static PriceList createDemoPriceList() {
//        //Create an instance of pen
//        Pen myPen = new Pen("Super Pen");
//        myPen.type = "Felt-tip";
//        myPen.enterDescription("This new pen is just amazing you need to try it!");
//        myPen.setPrice(5.00);
//
//        //Create an instance of Pencil
//        Pencil myPencil = new Pencil("Custom Pencil");
//        myPencil.enterDescription("This pencil is designed to stay sharp longer, and is comfortable in the hand.");
//        myPencil.setPrice(2.00);
//
//        //Create an instance of Notepad
//        Notepad myNotepad = new Notepad("Student Special");
//        myNotepad.enterDescription("240 leaf A4 lecture pad.");
//        myNotepad.setPrice(3.50);
//
//        //Create an instance of Eraser
//        Eraser myEraser = new Eraser("New and Improved Eraser");
//        myEraser.enterDescription("A long lasting smudgeless eraser for all kinds of pencils.");
//        myEraser.setPrice(1.50);
//
//        //Create an instance of PencilCase
//        PencilCase myPencilCase = new PencilCase("Basic Pencil Case");
//        myPencilCase.enterDescription("A small single zip plastic pencil case with lettering for names.");
//        myPencilCase.setPrice(3.00);
//
//        //Create and instance of WritingPack including 2x myPens, myEraser, myPencil and myPencilCase
//        WritingPack myWritingPack = new WritingPack("Special Writing Pack");
//        myWritingPack.pen1 = myPen;
//        myWritingPack.pen2 = myPen;
//        myWritingPack.pencil = myPencil;
//        myWritingPack.eraser = myEraser;
//        myWritingPack.pencilCase = myPencilCase;
//        myWritingPack.enterDescription("WritingPack including two super pens, a custom pencil,"
//                + " a new and improved eraser and a basic pencil case.");
//        myWritingPack.setPrice(15.00);
//
//        //create a price list with all these products in it and print it out
//        PriceList demoPriceList = new PriceList();
//        demoPriceList.addProduct(myPen);
//        demoPriceList.addProduct(myPencil);
//        demoPriceList.addProduct(myEraser);
//        demoPriceList.addProduct(myPencilCase);
//        demoPriceList.addProduct(myNotepad);
//        demoPriceList.addProduct(myWritingPack);
//
//        return demoPriceList;
//    }
}
